IF OBJECT_ID('P_PDV_VD_IT_REPROCESSA_TX_ICMS_IT') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_PDV_VD_IT_REPROCESSA_TX_ICMS_IT;
    END;
GO 

-- P_PDV_VD_IT_REPROCESSA_TX_ICMS_IT  9,'20190525','20190705',1
CREATE PROCEDURE P_PDV_VD_IT_REPROCESSA_TX_ICMS_IT (@CD_FILIAL INT , @DATA_INI DATE, @DATA_FIM DATE, @CONSULTA TINYINT  = 0 ) 
AS

/**************************************************************************************************************************************/

--DECLARE @CD_FILIAL INT = 9, 
--		@DATA_INI  DATE ='20190525' , 
--		@DATA_FIM  DATE	='20190705'

/**************************************************************************************************************************************/	  
SET NOCOUNT ON;


Create table #TmpPDV_Alterar (CD_EMP	int, 
							  CD_FILIAL int,
							  CD_VD		int, 
							  CD_IT		int,
							  PERC_ICMS_EST money,
							  PERC_RED	  money)
/**************************************************************************************************************************************/	  

insert into #TmpPDV_Alterar
SELECT
	  i.CD_EMP, 
	  i.CD_FILIAL,
	  i.CD_VD, 
	  i.CD_IT,
      c.PERC_ICMS_EST,
	  c.PERC_RED	  
FROM 
	 PDV_VD V
     INNER JOIN PDV_VD_IT I ON V.CD_EMP = I.CD_EMP
                               AND V.CD_FILIAL = I.CD_FILIAL
                               AND V.CD_VD = I.CD_VD
                               AND V.DT_VD = I.DT_VD
     OUTER APPLY UFD_EST_PROD_TRIB(1, V.CD_FILIAL, 1, V.CD_CLI, I.CD_PROD, 0, 0, 0, 1, 10, 0, 0, 0, 0, 0, 0) C
WHERE
      i.CD_EMP = 1
      AND V.CD_FILIAL = @CD_FILIAL
      AND i.DT_VD BETWEEN @DATA_INI AND @DATA_FIM
      AND i.CD_TRIB_FC = '000'
      AND i.TX_ICMS_IT = 0 ; 	  
	       
/**************************************************************************************************************************************/	  

	DECLARE @UF                 VARCHAR(2)
		  , @PERC_ALIQ_ESTADUAL MONEY;

	SELECT
		   @UF = UF
	FROM
		 PRC_FILIAL F
		 JOIN GLB_CID C ON F.CD_CID = C.CD_CID
	WHERE F.CD_FILIAL = @CD_FILIAL;

	SELECT
		   @PERC_ALIQ_ESTADUAL = ALIQ_ICMS
	FROM
		 EST_TRIB_ALIQ_ICMS
	WHERE UF_ORIG = @UF
		  AND UF_ORIG = UF_DEST;
	
	--------------------------------------------------------------------------------------------
	
	UPDATE  #TmpPDV_Alterar
		SET PERC_ICMS_EST =@PERC_ALIQ_ESTADUAL
			WHERE PERC_ICMS_EST=0;
	
	--------------------------------------------------------------------------------------------

/**************************************************************************************************************************************/

	IF @CONSULTA =0
	BEGIN
		select * from #TmpPDV_Alterar
	END
	
/**************************************************************************************************************************************/
	IF @CONSULTA =1
	BEGIN
		UPDATE I
		SET
			TX_ICMS_IT = PERC_ICMS_EST,
			TX_RED_IT  = PERC_RED
		FROM 
			PDV_VD_IT I 
			JOIN #TmpPDV_Alterar t ON 
					I.CD_EMP	= T.CD_EMP
				AND I.CD_FILIAL = T.CD_FILIAL
				AND I.CD_VD		= T.CD_VD
				AND I.CD_IT		= T.CD_IT
		WHERE
			  i.CD_EMP = 1
		  AND i.CD_FILIAL = @CD_FILIAL
		  AND i.DT_VD BETWEEN @DATA_INI AND @DATA_FIM ; 
	END
/**************************************************************************************************************************************/
GO
GO

IF  EXISTS (SELECT * FROM sys.objects	
				WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_IT_REPROCESSA_TX_ICMS_IT_EXEC_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_IT_REPROCESSA_TX_ICMS_IT_EXEC_ALL] 

go

Create procedure P_PDV_VD_IT_REPROCESSA_TX_ICMS_IT_EXEC_ALL 	(@DataIni date , @DataFim date) 

AS
set nocount on;

	DECLARE @cd_chave_FILIAL int;

	declare c_Chave CURSOR FAST_FORWARD FOR
	SELECT CD_FILIAL  
		FROM PRC_FILIAL 
		ORDER BY CD_FILIAL
	
	
	OPEN c_Chave
	FETCH NEXT FROM c_Chave INTO @cd_chave_FILIAL
	WHILE @@FETCH_STATUS = 0
		BEGIN

			PRINT 'Procesando lj ' + CONVERT(VARCHAR, @cd_chave_FILIAL)	+ ' Time ' + convert(varchar, getdate(), 108)

			EXEC P_PDV_VD_IT_REPROCESSA_TX_ICMS_IT @cd_chave_FILIAL ,@DataIni,@DataFim,1;

			FETCH NEXT FROM c_Chave INTO @cd_chave_FILIAL
		END
	CLOSE c_Chave;
	DEALLOCATE c_Chave;

GO

